package labirinto.utils;

import java.util.Observable;

public class Circle extends Observable {

	private int x, y, ray;

	public Circle(int x, int y, int ray) {
		super();
		this.x = x;
		this.y = y;
		this.ray = ray;
	}

	public void setX(int x) {
		this.x = x;
		/* observable. */setChanged(); // poiche il metodo setChanged è
										// protected-->posso chiamarlo solo
										// all'interno di classe figlia
		notifyObservers();
	}

	public void setY(int y) {
		this.y = y;
		setChanged();
		notifyObservers();
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public int getRay() {
		return ray;
	}

	public void setRay(int ray) {
		this.ray = ray;
	}

}
